%   Copyright  2020 University of Extremadura (UEx)
%
% getDataForSet
%  Input:
%   ids: data ids matrix (1 column)
%   beaconNumber: [beacon slot]
%
%  Output:
%  results: Logical index of matching criteria
% -----------------------------------------

function [results] = getFilterForBeaconSlot(ids,beaconNumber)
    results = zeros(1,size(ids,1));
    for i=1:1:size(ids,1)
        if (ids(i,4) == beaconNumber(1))
            if (ids(i,5) == beaconNumber(2))
                results(i) = 1;
            end
        end
    end
    
    results = logical(results);
end

